/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.Security;

import br.com.projetoa.apia.Security.TokenService;
import br.com.projetoa.apia.repository.AdministradorRepository;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class SecurityFilter
extends OncePerRequestFilter {
    @Autowired
    TokenService tokenService;
    @Autowired
    AdministradorRepository administradorRepository;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token = this.recoverToken(request);
        if (token != null) {
            String nome = this.tokenService.validateToken(token);
            UserDetails adm = this.administradorRepository.findUserDetailsByNome(nome);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)adm, null, adm.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String recoverToken(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            return null;
        }
        return authHeader.replace("Bearer ", "");
    }
}

