/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.Security;

import br.com.projetoa.apia.modelo.Administrador;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @Value(value="${api.security.token.secret}")
    private String secret;

    public String generateToken(Administrador adm) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            String token = JWT.create().withIssuer("adw182").withSubject(adm.getNome()).withExpiresAt(this.generateExpirationDate()).sign(algorithm);
            return token;
        }
        catch (JWTCreationException exception) {
            throw new RuntimeException("Erro ao gerar token", exception);
        }
    }

    public String validateToken(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            return JWT.require((Algorithm)algorithm).withIssuer("adw182").build().verify(token).getSubject();
        }
        catch (JWTVerificationException verificationException) {
            return "";
        }
    }

    private Instant generateExpirationDate() {
        return LocalDateTime.now().plusHours(2L).toInstant(ZoneOffset.of("-03:00"));
    }
}

