/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.Security.TokenService;
import br.com.projetoa.apia.controller.DizimistaController;
import br.com.projetoa.apia.modelo.Administrador;
import br.com.projetoa.apia.modelo.Comunidade;
import br.com.projetoa.apia.repository.AdministradorRepository;
import br.com.projetoa.apia.repository.ComunidadeRepository;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/administrador"})
public class AdministradorController {
    private static final Logger logger = LoggerFactory.getLogger(DizimistaController.class);
    @Autowired
    private AdministradorRepository administradorRepository;
    @Autowired
    private ComunidadeRepository comunidadeRepository;
    @Autowired
    private TokenService tokenService;

    @GetMapping(value={"/getAll"})
    public List<Administrador> listarAdministradores() {
        return this.administradorRepository.findAll();
    }

    @GetMapping(value={"/{id}"})
    public Optional<Administrador> getAdministradorPorId(@PathVariable Long id) {
        return this.administradorRepository.findById((Object)id);
    }

    @GetMapping(value={"/getByToken"})
    public ResponseEntity<Optional<Administrador>> getAdministradorByToken(@RequestHeader(value="Authorization") String authorizationHeader) {
        try {
            String token = authorizationHeader.replace("Bearer ", "");
            String nomeAdministrador = this.tokenService.validateToken(token);
            if (!nomeAdministrador.isEmpty()) {
                Optional administrador = this.administradorRepository.findByNome(nomeAdministrador);
                return ResponseEntity.ok((Object)administrador);
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(null);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/save"})
    public Administrador salvarAdministrador(@RequestBody Administrador administrador) {
        return (Administrador)this.administradorRepository.save((Object)administrador);
    }

    @PostMapping(value={"/{administradorId}/comunidade/{comunidadeId}"})
    public ResponseEntity<String> associarAdministradorAComunidade(@PathVariable Long administradorId, @PathVariable Long comunidadeId) {
        Optional optionalAdministrador = this.administradorRepository.findById((Object)administradorId);
        Optional optionalComunidade = this.comunidadeRepository.findById(comunidadeId);
        if (optionalAdministrador.isPresent() && optionalComunidade.isPresent()) {
            Administrador administrador = (Administrador)optionalAdministrador.get();
            Comunidade comunidade = (Comunidade)optionalComunidade.get();
            if (!comunidade.getAdministradores().contains(administrador)) {
                administrador.adicionarComunidade(comunidade);
                this.administradorRepository.save((Object)administrador);
                return ResponseEntity.ok((Object)"Administrador associado \u00e0 comunidade com sucesso.");
            }
            return ResponseEntity.badRequest().body((Object)"O administrador j\u00e1 est\u00e1 associado a esta comunidade.");
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/{id}"})
    public Administrador atualizarAdministrador(@PathVariable Long id, @RequestBody Administrador administrador) {
        if (this.administradorRepository.existsById((Object)id)) {
            administrador.setId(id);
            return (Administrador)this.administradorRepository.save((Object)administrador);
        }
        throw new RuntimeException("Administrador n\u00e3o encontrado com o ID: " + id);
    }

    @PutMapping(value={"/{id}/comunidadeAtiva/{comunidadeId}"})
    public ResponseEntity<Administrador> atualizarComunidadeAtiva(@PathVariable Long id, @PathVariable Long comunidadeId) {
        Optional optionalAdministrador = this.administradorRepository.findById((Object)id);
        Optional optionalComunidade = this.comunidadeRepository.findById(comunidadeId);
        if (optionalAdministrador.isPresent() && optionalComunidade.isPresent()) {
            Administrador administrador = (Administrador)optionalAdministrador.get();
            Comunidade novaComunidadeAtiva = (Comunidade)optionalComunidade.get();
            administrador.setComunidadeAtiva(novaComunidadeAtiva.getId());
            this.administradorRepository.save((Object)administrador);
            return ResponseEntity.ok((Object)administrador);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public void excluirAdministrador(@PathVariable Long id) {
        if (!this.administradorRepository.existsById((Object)id)) {
            throw new RuntimeException("Administrador n\u00e3o encontrado com o ID: " + id);
        }
        this.administradorRepository.deleteById((Object)id);
    }

    @GetMapping(value={"/autenticar"})
    public ResponseEntity<Administrador> autenticarAdministrador(@RequestParam String nome, @RequestParam String senha) {
        Administrador administrador;
        Optional optionalAdministrador = this.administradorRepository.findByNome(nome);
        logger.info("Tentou autenticar admin");
        if (optionalAdministrador.isPresent() && (administrador = (Administrador)optionalAdministrador.get()).getSenha().equals(senha)) {
            return ResponseEntity.ok((Object)administrador);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/findByNome"})
    public ResponseEntity<Administrador> getAdministradorPorNome(@RequestParam String nome) {
        Optional optionalAdministrador = this.administradorRepository.findByNome(nome);
        if (optionalAdministrador.isPresent()) {
            Administrador administrador = (Administrador)optionalAdministrador.get();
            return ResponseEntity.ok((Object)administrador);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/comunidades"})
    public ResponseEntity<List<Comunidade>> getComunidadesByAdministradorId(@PathVariable Long id) {
        Optional optionalAdministrador = this.administradorRepository.findById((Object)id);
        if (optionalAdministrador.isPresent()) {
            Administrador administrador = (Administrador)optionalAdministrador.get();
            List comunidades = administrador.getComunidades();
            return ResponseEntity.ok((Object)comunidades);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/comunidadeAtiva"})
    public ResponseEntity<Comunidade> getComunidadeAtivaByAdministradorId(@PathVariable Long id) {
        Administrador administrador;
        Long comunidadeAtivaId;
        Optional optionalAdministrador = this.administradorRepository.findById((Object)id);
        if (optionalAdministrador.isPresent() && (comunidadeAtivaId = (administrador = (Administrador)optionalAdministrador.get()).getComunidadeAtiva()) != null) {
            Optional optionalComunidade = this.comunidadeRepository.findById(comunidadeAtivaId);
            if (optionalComunidade.isPresent()) {
                Comunidade comunidadeAtiva = (Comunidade)optionalComunidade.get();
                return ResponseEntity.ok((Object)comunidadeAtiva);
            }
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/getIdByNome"})
    public ResponseEntity<Long> getIdByNome(@RequestParam String nome) {
        Optional optionalAdministrador = this.administradorRepository.findByNome(nome);
        if (optionalAdministrador.isPresent()) {
            Administrador administrador = (Administrador)optionalAdministrador.get();
            return ResponseEntity.ok((Object)administrador.getId());
        }
        return ResponseEntity.notFound().build();
    }
}

