/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.modelo.AsaasWebhook;
import br.com.projetoa.apia.modelo.Contribuicao;
import br.com.projetoa.apia.modelo.TaxaCemiterio;
import br.com.projetoa.apia.repository.ContribuicaoRepository;
import br.com.projetoa.apia.repository.TaxaCemiterioRepository;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/webhookAsaas"})
@CrossOrigin
public class AsaasWebhookController {
    @Autowired
    private ContribuicaoRepository contribuicaoRepository;
    @Autowired
    private TaxaCemiterioRepository taxaCemiterioRepository;

    @PostMapping
    public ResponseEntity<String> handleWebhook(@RequestBody AsaasWebhook webhook) {
        if (webhook.getPayment() == null) {
            return ResponseEntity.badRequest().body((Object)"Payment information is missing");
        }
        String paymentId = webhook.getPayment().getId();
        String status = webhook.getPayment().getStatus();
        String transactionReceiptUrl = webhook.getPayment().getCustomTransactionReceiptUrl();
        Optional optionalContribuicao = this.contribuicaoRepository.findByIdAsaas(paymentId);
        if (optionalContribuicao.isPresent()) {
            Contribuicao contribuicao = (Contribuicao)optionalContribuicao.get();
            contribuicao.setStatus(status);
            contribuicao.setUrlRecibo(transactionReceiptUrl);
            this.contribuicaoRepository.save((Object)contribuicao);
            return ResponseEntity.ok((Object)"Webhook processed successfully");
        }
        Optional optionalTaxa = this.taxaCemiterioRepository.findByIdAsaas(paymentId);
        if (optionalTaxa.isPresent()) {
            TaxaCemiterio taxaCemiterio = (TaxaCemiterio)optionalTaxa.get();
            taxaCemiterio.setStatus(status);
            taxaCemiterio.setUrlRecibo(transactionReceiptUrl);
            this.taxaCemiterioRepository.save((Object)taxaCemiterio);
            return ResponseEntity.ok((Object)"Webhook processed successfully");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"Payment not found");
    }
}

