/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.DTOs.AuthenticationDTO;
import br.com.projetoa.apia.DTOs.LoginResponseDTO;
import br.com.projetoa.apia.DTOs.RegisterDTO;
import br.com.projetoa.apia.Security.TokenService;
import br.com.projetoa.apia.modelo.Administrador;
import br.com.projetoa.apia.repository.AdministradorRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
@CrossOrigin
public class AuthenticationController {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private AdministradorRepository administradorRepository;
    @Autowired
    private TokenService tokenService;

    @PostMapping(value={"/login"})
    public ResponseEntity<LoginResponseDTO> login(@RequestBody AuthenticationDTO data) {
        UsernamePasswordAuthenticationToken usernamePassword = new UsernamePasswordAuthenticationToken((Object)data.nome(), (Object)data.senha());
        Authentication auth = this.authenticationManager.authenticate((Authentication)usernamePassword);
        String token = this.tokenService.generateToken((Administrador)auth.getPrincipal());
        return ResponseEntity.ok((Object)new LoginResponseDTO(token));
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<Administrador> register(@RequestBody RegisterDTO data) {
        if (this.administradorRepository.findUserDetailsByNome(data.nome()) != null) {
            return ResponseEntity.badRequest().build();
        }
        String encryptedPassword = new BCryptPasswordEncoder().encode((CharSequence)data.senha());
        Administrador newUser = new Administrador(data.nome(), encryptedPassword, data.role(), data.master());
        this.administradorRepository.save((Object)newUser);
        return ResponseEntity.ok((Object)newUser);
    }
}

