/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.controller.DizimistaController;
import br.com.projetoa.apia.modelo.Comunidade;
import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.repository.ComunidadeRepository;
import br.com.projetoa.apia.service.AsaasService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/comunidade"})
@CrossOrigin
public class ComunidadeController {
    @Autowired
    private ComunidadeRepository comunidadeRepository;
    @Autowired
    private AsaasService asaasService;
    private static final Logger logger = LoggerFactory.getLogger(DizimistaController.class);

    @GetMapping(value={"/getAll"})
    public List<Comunidade> getAllComunidades() {
        return this.comunidadeRepository.findAll();
    }

    @GetMapping(value={"/{comunidadeId}"})
    public ResponseEntity<Comunidade> getComunidadeById(@PathVariable Long comunidadeId) throws IOException, InterruptedException {
        Comunidade comunidade = this.comunidadeRepository.findById(comunidadeId).orElse(null);
        if (comunidade != null) {
            return ResponseEntity.ok((Object)comunidade);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/getComunidadeByDizimista/{dizimistaId}"})
    public ResponseEntity<Comunidade> getComunidadeByDizimista(@PathVariable Long dizimistaId) {
        Optional optionalComunidade = this.comunidadeRepository.findByDizimistasId(dizimistaId);
        if (optionalComunidade.isPresent()) {
            return ResponseEntity.ok((Object)((Comunidade)optionalComunidade.get()));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{comunidadeId}/nomeDizimista/{dizimistaNome}"})
    public ResponseEntity<List<Dizimista>> getDizimistasByNomeAndComunidade(@PathVariable Long comunidadeId, @PathVariable String dizimistaNome) {
        Optional optionalComunidade = this.comunidadeRepository.findById(comunidadeId);
        if (optionalComunidade.isPresent()) {
            Comunidade comunidade = (Comunidade)optionalComunidade.get();
            List dizimistasFiltrados = comunidade.getDizimistas().stream().filter(dizimista -> dizimista.getNome().toLowerCase().contains(dizimistaNome.toLowerCase())).collect(Collectors.toList());
            return ResponseEntity.ok(dizimistasFiltrados);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{comunidadeId}/dizimistas"})
    public ResponseEntity<List<Dizimista>> getDizimistasByComunidade(@PathVariable Long comunidadeId) {
        Optional optionalComunidade = this.comunidadeRepository.findById(comunidadeId);
        if (optionalComunidade.isPresent()) {
            Comunidade comunidade = (Comunidade)optionalComunidade.get();
            List dizimistas = comunidade.getDizimistas();
            return ResponseEntity.ok((Object)dizimistas);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/save"})
    public Comunidade saveComunidade(@RequestBody Comunidade comunidade) {
        return (Comunidade)this.comunidadeRepository.save((Object)comunidade);
    }

    @PutMapping(value={"/{comunidadeId}/addDizimista"})
    public ResponseEntity<Comunidade> addDizimistaToComunidade(@PathVariable Long comunidadeId, @RequestBody Dizimista dizimista) {
        Optional optionalComunidade = this.comunidadeRepository.findById(comunidadeId);
        if (optionalComunidade.isPresent()) {
            Comunidade comunidade = (Comunidade)optionalComunidade.get();
            comunidade.adicionarDizimista(dizimista);
            Comunidade updatedComunidade = (Comunidade)this.comunidadeRepository.save((Object)comunidade);
            return ResponseEntity.ok((Object)updatedComunidade);
        }
        return ResponseEntity.notFound().build();
    }
}

