/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.modelo.Contribuicao;
import br.com.projetoa.apia.repository.ContribuicaoRepository;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contribuicao"})
@CrossOrigin
public class ContribuicaoController {
    @Autowired
    private ContribuicaoRepository contribuicaoRepository;

    @PostMapping(value={"/save"})
    public ResponseEntity<Contribuicao> createContribuicao(@RequestBody Contribuicao contribuicao) {
        contribuicao.setData(LocalDateTime.now());
        Contribuicao novaContribuicao = (Contribuicao)this.contribuicaoRepository.save((Object)contribuicao);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)novaContribuicao);
    }

    @GetMapping(value={"/getAll"})
    public List<Contribuicao> getAllContribuicoes() {
        return this.contribuicaoRepository.findAll();
    }

    @GetMapping(value={"/{contribuicaoId}"})
    public ResponseEntity<Contribuicao> getContribuicaoById(@PathVariable Long contribuicaoId) {
        Optional optionalContribuicao = this.contribuicaoRepository.findById((Object)contribuicaoId);
        return optionalContribuicao.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{contribuicaoId}"})
    public ResponseEntity<Contribuicao> updateContribuicao(@PathVariable Long contribuicaoId, @RequestBody Contribuicao contribuicaoAtualizada) {
        Optional optionalContribuicao = this.contribuicaoRepository.findById((Object)contribuicaoId);
        if (optionalContribuicao.isPresent()) {
            return ResponseEntity.ok((Object)contribuicaoAtualizada);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{contribuicaoId}"})
    public ResponseEntity<Void> deleteContribuicao(@PathVariable Long contribuicaoId) {
        Optional optionalContribuicao = this.contribuicaoRepository.findById((Object)contribuicaoId);
        if (optionalContribuicao.isPresent()) {
            this.contribuicaoRepository.deleteById((Object)contribuicaoId);
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

