/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.DTOs.DashboardDTO;
import br.com.projetoa.apia.service.DashboardService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard"})
@CrossOrigin
public class DashboardController {
    private final DashboardService dashboardService;

    @Autowired
    public DashboardController(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }

    @GetMapping(value={"/genero"})
    public ResponseEntity<DashboardDTO> getStatisticsByCommunity(@RequestParam Long communityId) {
        if (communityId == null) {
            return ResponseEntity.badRequest().build();
        }
        DashboardDTO dashboard = this.dashboardService.calcularEstatisticasSexo(communityId);
        if (dashboard == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)dashboard);
    }

    @GetMapping(value={"/totalRecebidoComunidade/{communityId}"})
    public ResponseEntity<Double> getTotalRecebidoByCommunity(@PathVariable Long communityId) {
        if (communityId == null) {
            return ResponseEntity.badRequest().build();
        }
        double totalRecebido = this.dashboardService.calcularTotalRecebido(communityId);
        return ResponseEntity.ok((Object)totalRecebido);
    }

    @GetMapping(value={"/totalRecebidoMensal/{communityId}"})
    public ResponseEntity<Map<String, Double>> getTotalRecebidoMensalByCommunity(@PathVariable Long communityId) {
        if (communityId == null) {
            return ResponseEntity.badRequest().build();
        }
        Map totalRecebidoMensal = this.dashboardService.calcularTotalRecebidoPorMes(communityId);
        return ResponseEntity.ok((Object)totalRecebidoMensal);
    }

    @GetMapping(value={"/idadesDizimistas/{communityId}"})
    public ResponseEntity<Map<String, Long>> getIdadesEDistribuicaoByCommunity(@PathVariable Long communityId) {
        if (communityId == null) {
            return ResponseEntity.badRequest().build();
        }
        Map idadesEDistribuicao = this.dashboardService.calcularIdadesEDistribuicao(communityId);
        return ResponseEntity.ok((Object)idadesEDistribuicao);
    }

    @GetMapping(value={"/totalRecebidoParoquia/{paroquiaId}"})
    public ResponseEntity<Double> getTotalRecebidoForParoquia(@PathVariable Long paroquiaId) {
        if (paroquiaId == null) {
            return ResponseEntity.badRequest().build();
        }
        double totalRecebidoParoquia = this.dashboardService.calcularTotalRecebidoParoquia(paroquiaId);
        return ResponseEntity.ok((Object)totalRecebidoParoquia);
    }

    @GetMapping(value={"/totalRecebidoMensalParoquia/{paroquiaId}"})
    public ResponseEntity<Map<String, Double>> getTotalRecebidoMensalForParoquia(@PathVariable Long paroquiaId) {
        if (paroquiaId == null) {
            return ResponseEntity.badRequest().build();
        }
        Map totalRecebidoMensalParoquia = this.dashboardService.calcularTotalRecebidoMensalParoquia(paroquiaId);
        return ResponseEntity.ok((Object)totalRecebidoMensalParoquia);
    }

    @GetMapping(value={"/idadesDizimistasParoquia/{paroquiaId}"})
    public ResponseEntity<Map<String, Long>> getIdadesDizimistasForParoquia(@PathVariable Long paroquiaId) {
        if (paroquiaId == null) {
            return ResponseEntity.badRequest().build();
        }
        Map idadesDizimistasParoquia = this.dashboardService.calcularIdadesEDistribuicaoParoquia(paroquiaId);
        return ResponseEntity.ok((Object)idadesDizimistasParoquia);
    }

    @GetMapping(value={"/generoParoquia/{paroquiaId}"})
    public ResponseEntity<DashboardDTO> getStatisticsForParoquia(@PathVariable Long paroquiaId) {
        if (paroquiaId == null) {
            return ResponseEntity.badRequest().build();
        }
        DashboardDTO dashboard = this.dashboardService.calcularEstatisticasSexoParoquia(paroquiaId);
        if (dashboard == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)dashboard);
    }

    @GetMapping(value={"/quantidadeDizimistasAtivos/{paroquiaId}"})
    public ResponseEntity<Long> getQuantidadeDizimistasAtivosForParoquia(@PathVariable Long paroquiaId) {
        if (paroquiaId == null) {
            return ResponseEntity.badRequest().build();
        }
        long totalAtivos = this.dashboardService.calcularDizimistasAtivosParoquia(paroquiaId);
        return ResponseEntity.ok((Object)totalAtivos);
    }

    @GetMapping(value={"/quantidadeDizimistasInativos/{paroquiaId}"})
    public ResponseEntity<Long> getQuantidadeDizimistasInativosForParoquia(@PathVariable Long paroquiaId) {
        if (paroquiaId == null) {
            return ResponseEntity.badRequest().build();
        }
        long totalInativos = this.dashboardService.calcularDizimistasInativosParoquia(paroquiaId);
        return ResponseEntity.ok((Object)totalInativos);
    }

    @GetMapping(value={"/quantidadeDizimistasFieis/{paroquiaId}"})
    public ResponseEntity<Long> getQuantidadeDizimistasFieisForParoquia(@PathVariable Long paroquiaId) {
        if (paroquiaId == null) {
            return ResponseEntity.badRequest().build();
        }
        long totalFieis = this.dashboardService.calcularTotalFieisParoquia(paroquiaId);
        return ResponseEntity.ok((Object)totalFieis);
    }
}

