/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.Security.TokenService;
import br.com.projetoa.apia.modelo.Atividade;
import br.com.projetoa.apia.modelo.Contribuicao;
import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.modelo.GrupoCemiterio;
import br.com.projetoa.apia.repository.AtividadeRepository;
import br.com.projetoa.apia.repository.DizimistaRepository;
import br.com.projetoa.apia.repository.GrupoCemiterioRepository;
import br.com.projetoa.apia.service.AsaasService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dizimista"})
public class DizimistaController {
    @Autowired
    private DizimistaRepository dizimistaRepository;
    @Autowired
    private GrupoCemiterioRepository grupoCemiterioRepository;
    @Autowired
    private AtividadeRepository atividadeRepository;
    @Autowired
    private AsaasService asaasService;
    @Autowired
    private TokenService tokenService;
    private static final Logger logger = LoggerFactory.getLogger(DizimistaController.class);

    @GetMapping(value={"/getAll"})
    public List<Dizimista> getAllDizimistas() {
        logger.info("Chamada para getAllDizimistas realizada");
        return this.dizimistaRepository.findAll();
    }

    @GetMapping(value={"/{id}"})
    public Dizimista getDizimistaById(@PathVariable Long id) {
        Dizimista dizimista = this.dizimistaRepository.findById((Object)id).orElse(null);
        return dizimista;
    }

    @GetMapping(value={"/getByName/{nome}"})
    public List<Dizimista> getDizimistasByNome(@PathVariable String nome) {
        List dizimistas = this.dizimistaRepository.findByNomeContaining(nome);
        return dizimistas;
    }

    @GetMapping(value={"conjugeDizimista/{id}"})
    public ResponseEntity<Dizimista> getCOnjugeById(@PathVariable Long id) {
        Dizimista dizimista = this.dizimistaRepository.findById((Object)id).orElse(null);
        if (dizimista != null) {
            Dizimista conjugue = dizimista.getConjugue();
            if (conjugue != null) {
                // empty if block
            }
            return ResponseEntity.ok((Object)conjugue);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/save"})
    public Dizimista saveDizimista(@RequestBody Dizimista dizimista, @RequestHeader(value="Authorization") String authorizationHeader) throws IOException, InterruptedException {
        String token = authorizationHeader.replace("Bearer ", "");
        String nomeAdministrador = this.tokenService.validateToken(token);
        dizimista.setDataCadastro();
        dizimista.setPagouDizimo(true);
        dizimista.setAtivo(true);
        Dizimista dizimistaSalvo = (Dizimista)this.dizimistaRepository.save((Object)dizimista);
        GrupoCemiterio grupoCemiterio = new GrupoCemiterio(dizimistaSalvo);
        this.grupoCemiterioRepository.save((Object)grupoCemiterio);
        dizimistaSalvo.setGrupoCemiterio(grupoCemiterio);
        this.dizimistaRepository.save((Object)dizimistaSalvo);
        if (dizimistaSalvo.getCpf() != null && !dizimistaSalvo.getCpf().trim().isEmpty()) {
            this.asaasService.criarClienteAsaas(nomeAdministrador, dizimistaSalvo);
        }
        return dizimistaSalvo;
    }

    @PostMapping(value={"/autocadastro"})
    public Dizimista autoSaveDizimista(@RequestBody Dizimista dizimista, @RequestHeader(value="Authorization") String authorizationHeader) throws IOException, InterruptedException {
        String token = authorizationHeader.replace("Bearer ", "");
        String nomeAdministrador = this.tokenService.validateToken(token);
        dizimista.setDataCadastro();
        dizimista.setPagouDizimo(true);
        dizimista.setAtivo(false);
        Dizimista dizimistaSalvo = (Dizimista)this.dizimistaRepository.save((Object)dizimista);
        this.asaasService.criarClienteAsaas(nomeAdministrador, dizimistaSalvo);
        return dizimistaSalvo;
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Map<String, String>> deleteDizimista(@PathVariable Long id) {
        try {
            this.dizimistaRepository.deleteById((Object)id);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "OK");
            response.put("mensagem", "OK");
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "ERRO");
            response.put("mensagem", e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(response);
        }
    }

    @PostMapping(value={"/addContribuicao/{dizimistaId}"})
    public ResponseEntity<Contribuicao> addContribuicaoToDizimista(@PathVariable Long dizimistaId, @RequestBody Contribuicao contribuicao, @RequestHeader(value="Authorization") String authorizationHeader) throws IOException, InterruptedException {
        Optional optionalDizimista = this.dizimistaRepository.findById((Object)dizimistaId);
        if (optionalDizimista.isPresent()) {
            Dizimista dizimista = (Dizimista)optionalDizimista.get();
            dizimista.getContribuicoes().add(contribuicao);
            this.dizimistaRepository.save((Object)dizimista);
            String token = authorizationHeader.replace("Bearer ", "");
            String nomeAdministrador = this.tokenService.validateToken(token);
            this.asaasService.criarCobranca(dizimista, contribuicao);
            return ResponseEntity.ok((Object)contribuicao);
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"{dizimistaId}/addConjugue/{conjugeId}"})
    public ResponseEntity<Dizimista> addConjugueToDizimista(@PathVariable Long dizimistaId, @PathVariable Long conjugeId) {
        Optional optionalDizimista = this.dizimistaRepository.findById((Object)dizimistaId);
        if (optionalDizimista.isPresent()) {
            Dizimista dizimista = (Dizimista)optionalDizimista.get();
            Optional optionalConjuge = this.dizimistaRepository.findById((Object)conjugeId);
            if (optionalConjuge.isPresent()) {
                Dizimista conjuge = (Dizimista)optionalConjuge.get();
                dizimista.setConjugue(conjuge);
                dizimista.setDatCasamento(conjuge.getDatCasamento());
                dizimista.setSacCasamento(conjuge.isSacCasamento());
                this.dizimistaRepository.save((Object)dizimista);
                conjuge.setConjugue(dizimista);
                conjuge.setDatCasamento(dizimista.getDatCasamento());
                this.dizimistaRepository.save((Object)conjuge);
                return ResponseEntity.ok((Object)dizimista);
            }
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/contribuicoes"})
    public ResponseEntity<List<Contribuicao>> getContribuicoesByDizimistaId(@PathVariable Long id) {
        Optional optionalDizimista = this.dizimistaRepository.findById((Object)id);
        if (optionalDizimista.isPresent()) {
            Dizimista dizimista = (Dizimista)optionalDizimista.get();
            List contribuicoes = dizimista.getContribuicoes();
            return ResponseEntity.ok((Object)contribuicoes);
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Dizimista> updateDizimista(@RequestHeader(value="Authorization") String authorizationHeader, @PathVariable Long id, @RequestBody Dizimista updatedDizimista) throws IOException, InterruptedException {
        String token = authorizationHeader.replace("Bearer ", "");
        String nomeAdministrador = this.tokenService.validateToken(token);
        Optional optionalDizimista = this.dizimistaRepository.findById((Object)id);
        if (optionalDizimista.isPresent()) {
            Dizimista dizimista = (Dizimista)optionalDizimista.get();
            dizimista.setNome(updatedDizimista.getNome());
            dizimista.setNascimento(updatedDizimista.getNascimento());
            dizimista.setCpf(updatedDizimista.getCpf());
            dizimista.setEndereco(updatedDizimista.getEndereco());
            dizimista.setTelefone(updatedDizimista.getTelefone());
            dizimista.setEmail(updatedDizimista.getEmail());
            dizimista.setConjugue(updatedDizimista.getConjugue());
            dizimista.setContribuicoes(updatedDizimista.getContribuicoes());
            dizimista.setSacBatismo(updatedDizimista.isSacBatismo());
            dizimista.setDatBatismo(updatedDizimista.getDatBatismo());
            dizimista.setSacComunhao(updatedDizimista.isSacComunhao());
            dizimista.setDatComunhao(updatedDizimista.getDatComunhao());
            dizimista.setSacCrisma(updatedDizimista.isSacCrisma());
            dizimista.setDatCrisma(updatedDizimista.getDatCrisma());
            dizimista.setSacCasamento(updatedDizimista.isSacCasamento());
            dizimista.setDatCasamento(updatedDizimista.getDatCasamento());
            dizimista.setPagouDizimo(updatedDizimista.isPagouDizimo());
            dizimista.setAtivo(updatedDizimista.isAtivo());
            dizimista.setIdAsaas(updatedDizimista.getIdAsaas());
            dizimista = (Dizimista)this.dizimistaRepository.save((Object)dizimista);
            if (dizimista.getCpf() != null && dizimista.getCpf().trim() != "") {
                this.asaasService.criarClienteAsaas(nomeAdministrador, dizimista);
            }
            return ResponseEntity.ok((Object)dizimista);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/{dizimistaId}/addAtividade"})
    public ResponseEntity<Atividade> addAtividadeToDizimista(@PathVariable Long dizimistaId, @RequestBody Atividade atividade) {
        Optional optionalDizimista = this.dizimistaRepository.findById((Object)dizimistaId);
        if (optionalDizimista.isPresent()) {
            Dizimista dizimista = (Dizimista)optionalDizimista.get();
            atividade.setDizimista(dizimista);
            this.atividadeRepository.save((Object)atividade);
            return ResponseEntity.ok((Object)atividade);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{dizimistaId}/atividades"})
    public ResponseEntity<List<Atividade>> getAtividadesByDizimistaId(@PathVariable Long dizimistaId) {
        Optional optionalDizimista = this.dizimistaRepository.findById((Object)dizimistaId);
        if (optionalDizimista.isPresent()) {
            Dizimista dizimista = (Dizimista)optionalDizimista.get();
            List atividades = dizimista.getAtividades();
            return ResponseEntity.ok((Object)atividades);
        }
        return ResponseEntity.notFound().build();
    }
}

