/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.modelo.GrupoCemiterio;
import br.com.projetoa.apia.modelo.TaxaCemiterio;
import br.com.projetoa.apia.repository.DizimistaRepository;
import br.com.projetoa.apia.repository.GrupoCemiterioRepository;
import br.com.projetoa.apia.service.AsaasService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/grupoCemiterio"})
public class GrupoCemiterioController {
    @Autowired
    private DizimistaRepository dizimistaRepository;
    @Autowired
    private GrupoCemiterioRepository grupoCemiterioRepository;
    @Autowired
    private AsaasService asaasService;

    @PostMapping(value={"/{grupoId}/addDizimista/{dizimistaId}"})
    public ResponseEntity<GrupoCemiterio> addDizimistaToGrupo(@PathVariable Long grupoId, @PathVariable Long dizimistaId) {
        Optional optionalGrupo = this.grupoCemiterioRepository.findById((Object)grupoId);
        if (optionalGrupo.isPresent()) {
            GrupoCemiterio grupoCemiterio = (GrupoCemiterio)optionalGrupo.get();
            Optional optionalDizimista = this.dizimistaRepository.findById((Object)dizimistaId);
            if (optionalDizimista.isPresent()) {
                Dizimista dizimista = (Dizimista)optionalDizimista.get();
                grupoCemiterio.addDizimista(dizimista);
                this.grupoCemiterioRepository.save((Object)grupoCemiterio);
                return ResponseEntity.ok((Object)grupoCemiterio);
            }
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{grupoId}/removeDizimista/{dizimistaId}"})
    public ResponseEntity<GrupoCemiterio> removeDizimistaFromGrupo(@PathVariable Long grupoId, @PathVariable Long dizimistaId) {
        Optional optionalGrupo = this.grupoCemiterioRepository.findById((Object)grupoId);
        if (optionalGrupo.isPresent()) {
            GrupoCemiterio grupoCemiterio = (GrupoCemiterio)optionalGrupo.get();
            Optional optionalDizimista = this.dizimistaRepository.findById((Object)dizimistaId);
            if (optionalDizimista.isPresent()) {
                Dizimista dizimista = (Dizimista)optionalDizimista.get();
                GrupoCemiterio novoGrupo = new GrupoCemiterio();
                novoGrupo.setResponsavel(dizimista);
                novoGrupo.addDizimista(dizimista);
                this.grupoCemiterioRepository.save((Object)novoGrupo);
                dizimista.setGrupoCemiterio(novoGrupo);
                this.dizimistaRepository.save((Object)dizimista);
                grupoCemiterio.removeDizimista(dizimista);
                this.grupoCemiterioRepository.save((Object)grupoCemiterio);
                return ResponseEntity.ok((Object)grupoCemiterio);
            }
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/{grupoId}/setResponsavel/{responsavelId}"})
    public ResponseEntity<GrupoCemiterio> setResponsavelDoGrupo(@PathVariable Long grupoId, @PathVariable Long responsavelId) {
        Optional optionalGrupo = this.grupoCemiterioRepository.findById((Object)grupoId);
        if (optionalGrupo.isPresent()) {
            GrupoCemiterio grupoCemiterio = (GrupoCemiterio)optionalGrupo.get();
            Optional optionalResponsavel = this.dizimistaRepository.findById((Object)responsavelId);
            if (optionalResponsavel.isPresent()) {
                Dizimista responsavel = (Dizimista)optionalResponsavel.get();
                grupoCemiterio.setResponsavel(responsavel);
                this.grupoCemiterioRepository.save((Object)grupoCemiterio);
                return ResponseEntity.ok((Object)grupoCemiterio);
            }
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{grupoId}/listarDizimistas"})
    public ResponseEntity<GrupoCemiterio> listarDizimistasDoGrupo(@PathVariable Long grupoId) {
        Optional optionalGrupo = this.grupoCemiterioRepository.findById((Object)grupoId);
        if (optionalGrupo.isPresent()) {
            GrupoCemiterio grupoCemiterio = (GrupoCemiterio)optionalGrupo.get();
            return ResponseEntity.ok((Object)grupoCemiterio);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/getGrupoByDizimista/{dizimistaId}"})
    public ResponseEntity<GrupoCemiterio> getGrupoByDizimista(@PathVariable Long dizimistaId) {
        Optional optionalDizimista = this.dizimistaRepository.findById((Object)dizimistaId);
        if (optionalDizimista.isPresent()) {
            Dizimista dizimista = (Dizimista)optionalDizimista.get();
            if (dizimista.getGrupoCemiterio() != null) {
                return ResponseEntity.ok((Object)dizimista.getGrupoCemiterio());
            }
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/{grupoId}/addTaxaCemiterio"})
    public ResponseEntity<TaxaCemiterio> addTaxaCemiterioToGrupo(@PathVariable Long grupoId, @RequestBody TaxaCemiterio taxaCemiterio) throws IOException, InterruptedException {
        Optional optionalGrupo = this.grupoCemiterioRepository.findById((Object)grupoId);
        if (optionalGrupo.isPresent()) {
            GrupoCemiterio grupoCemiterio = (GrupoCemiterio)optionalGrupo.get();
            Dizimista dizimista = grupoCemiterio.getAdministrador();
            grupoCemiterio.addTaxaCemiterio(taxaCemiterio);
            this.grupoCemiterioRepository.save((Object)grupoCemiterio);
            this.asaasService.criarTaxa(dizimista, taxaCemiterio, grupoCemiterio);
            return ResponseEntity.ok((Object)taxaCemiterio);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{grupoId}/removeTaxaCemiterio/{taxaCemiterioId}"})
    public ResponseEntity<GrupoCemiterio> removeTaxaCemiterioFromGrupo(@PathVariable Long grupoId, @PathVariable Long taxaCemiterioId) {
        Optional optionalGrupo = this.grupoCemiterioRepository.findById((Object)grupoId);
        if (optionalGrupo.isPresent()) {
            GrupoCemiterio grupoCemiterio = (GrupoCemiterio)optionalGrupo.get();
            grupoCemiterio.removeTaxaCemiterioById(taxaCemiterioId);
            this.grupoCemiterioRepository.save((Object)grupoCemiterio);
            return ResponseEntity.ok((Object)grupoCemiterio);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{grupoId}"})
    public ResponseEntity<?> removerGrupoCemiterio(@PathVariable Long grupoId) {
        Optional optionalGrupo = this.grupoCemiterioRepository.findById((Object)grupoId);
        if (optionalGrupo.isPresent()) {
            this.grupoCemiterioRepository.deleteById((Object)grupoId);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{grupoId}/listarTaxasCemiterio"})
    public ResponseEntity<List<TaxaCemiterio>> listarTaxasCemiterioDoGrupo(@PathVariable Long grupoId) {
        Optional optionalGrupo = this.grupoCemiterioRepository.findById((Object)grupoId);
        if (optionalGrupo.isPresent()) {
            GrupoCemiterio grupoCemiterio = (GrupoCemiterio)optionalGrupo.get();
            List taxasCemiterio = grupoCemiterio.getTaxasCemiterio();
            return ResponseEntity.ok((Object)taxasCemiterio);
        }
        return ResponseEntity.notFound().build();
    }
}

