/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.Security.TokenService;
import br.com.projetoa.apia.service.DizimistaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
@CrossOrigin
public class ImportController {
    @Autowired
    private DizimistaService dizimistaService;
    @Autowired
    private TokenService tokenService;

    @PostMapping(value={"/import"})
    public ResponseEntity<String> importCSV(@RequestParam(value="file") MultipartFile file, long comunidadeId, @RequestHeader(value="Authorization") String authorizationHeader) {
        String token = authorizationHeader.replace("Bearer ", "");
        String nomeAdministrador = this.tokenService.validateToken(token);
        try {
            this.dizimistaService.importCSV(nomeAdministrador, file, Long.valueOf(comunidadeId));
            return ResponseEntity.ok((Object)"Arquivo CSV importado com sucesso.");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Erro ao importar o arquivo CSV: " + e.getMessage()));
        }
    }
}

