/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.modelo.Comunidade;
import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.modelo.Formacao;
import br.com.projetoa.apia.modelo.Paroquia;
import br.com.projetoa.apia.repository.ComunidadeRepository;
import br.com.projetoa.apia.repository.FormacaoRepository;
import br.com.projetoa.apia.repository.ParoquiaRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/paroquia"})
@CrossOrigin
public class ParoquiaController {
    @Autowired
    private ParoquiaRepository paroquiaRepository;
    @Autowired
    private ComunidadeRepository comunidadeRepository;
    @Autowired
    private FormacaoRepository formacaoRepository;

    @GetMapping(value={"/getAll"})
    public List<Paroquia> getAllParoquias() {
        return this.paroquiaRepository.findAll();
    }

    @GetMapping(value={"/{paroquiaId}"})
    public ResponseEntity<Paroquia> getParoquiaById(@PathVariable Long paroquiaId) {
        Paroquia paroquia = this.paroquiaRepository.findById((Object)paroquiaId).orElse(null);
        if (paroquia != null) {
            return ResponseEntity.ok((Object)paroquia);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{paroquiaId}/comunidades"})
    public ResponseEntity<List<Comunidade>> getComunidadesDaParoquia(@PathVariable Long paroquiaId) {
        Optional optionalParoquia = this.paroquiaRepository.findById((Object)paroquiaId);
        if (optionalParoquia.isPresent()) {
            Paroquia paroquia = (Paroquia)optionalParoquia.get();
            List comunidades = paroquia.getComunidades();
            return ResponseEntity.ok((Object)comunidades);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/save"})
    public Paroquia saveParoquia(@RequestBody Paroquia paroquia) {
        return (Paroquia)this.paroquiaRepository.save((Object)paroquia);
    }

    @PutMapping(value={"/{paroquiaId}/addComunidade"})
    public ResponseEntity<Paroquia> addComunidadeToParoquia(@PathVariable Long paroquiaId, @RequestBody Comunidade comunidade) {
        Optional optionalParoquia = this.paroquiaRepository.findById((Object)paroquiaId);
        if (optionalParoquia.isPresent()) {
            Paroquia paroquia = (Paroquia)optionalParoquia.get();
            paroquia.adicionarComunidade(comunidade);
            Paroquia updatedParoquia = (Paroquia)this.paroquiaRepository.save((Object)paroquia);
            return ResponseEntity.ok((Object)updatedParoquia);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/paroquiaByComunidadeId/{comunidadeId}"})
    public ResponseEntity<Paroquia> getParoquiaByComunidadeId(@PathVariable Long comunidadeId) {
        Comunidade comunidade;
        Paroquia paroquia;
        Optional optionalComunidade = this.comunidadeRepository.findById(comunidadeId);
        if (optionalComunidade.isPresent() && (paroquia = this.paroquiaRepository.findParoquiaByComunidade(comunidade = (Comunidade)optionalComunidade.get())) != null) {
            return ResponseEntity.ok((Object)paroquia);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{paroquiaId}/dizimistas"})
    public ResponseEntity<List<Dizimista>> getDizimistasDaParoquia(@PathVariable Long paroquiaId) {
        Optional optionalParoquia = this.paroquiaRepository.findById((Object)paroquiaId);
        if (optionalParoquia.isPresent()) {
            Paroquia paroquia = (Paroquia)optionalParoquia.get();
            List comunidades = paroquia.getComunidades();
            ArrayList dizimistasDaParoquia = new ArrayList();
            for (Comunidade comunidade : comunidades) {
                List dizimistasDaComunidade = comunidade.getDizimistas();
                dizimistasDaParoquia.addAll(dizimistasDaComunidade);
            }
            return ResponseEntity.ok(dizimistasDaParoquia);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/{paroquiaId}/addFormacao"})
    public ResponseEntity<Paroquia> addFormacaoToParoquia(@PathVariable Long paroquiaId, @RequestBody Formacao formacao) {
        Optional optionalParoquia = this.paroquiaRepository.findById((Object)paroquiaId);
        if (optionalParoquia.isPresent()) {
            Paroquia paroquia = (Paroquia)optionalParoquia.get();
            formacao.setParoquia(paroquia);
            Formacao savedFormacao = (Formacao)this.formacaoRepository.save((Object)formacao);
            paroquia.adicionarFormacao(savedFormacao);
            this.paroquiaRepository.save((Object)paroquia);
            return ResponseEntity.ok((Object)paroquia);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{paroquiaId}/formacoes"})
    public ResponseEntity<List<Formacao>> getFormacoesDaParoquia(@PathVariable Long paroquiaId) {
        Optional optionalParoquia = this.paroquiaRepository.findById((Object)paroquiaId);
        if (optionalParoquia.isPresent()) {
            Paroquia paroquia = (Paroquia)optionalParoquia.get();
            List formacoes = paroquia.getFormacoes();
            return ResponseEntity.ok((Object)formacoes);
        }
        return ResponseEntity.notFound().build();
    }
}

