/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.modelo.TaxaCemiterio;
import br.com.projetoa.apia.repository.TaxaCemiterioRepository;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taxacemiterio"})
@CrossOrigin
public class TaxaCemiterioController {
    @Autowired
    private TaxaCemiterioRepository taxaCemiterioRepository;

    @PostMapping(value={"/save"})
    public ResponseEntity<TaxaCemiterio> createTaxaCemiterio(@RequestBody TaxaCemiterio taxaCemiterio) {
        taxaCemiterio.setData(LocalDateTime.now());
        TaxaCemiterio novaTaxaCemiterio = (TaxaCemiterio)this.taxaCemiterioRepository.save((Object)taxaCemiterio);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)novaTaxaCemiterio);
    }

    @GetMapping(value={"/getAll"})
    public List<TaxaCemiterio> getAllTaxasCemiterio() {
        return this.taxaCemiterioRepository.findAll();
    }

    @GetMapping(value={"/{taxaCemiterioId}"})
    public ResponseEntity<TaxaCemiterio> getTaxaCemiterioById(@PathVariable Long taxaCemiterioId) {
        Optional optionalTaxaCemiterio = this.taxaCemiterioRepository.findById((Object)taxaCemiterioId);
        return optionalTaxaCemiterio.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{taxaCemiterioId}"})
    public ResponseEntity<TaxaCemiterio> updateTaxaCemiterio(@PathVariable Long taxaCemiterioId, @RequestBody TaxaCemiterio taxaCemiterioAtualizada) {
        Optional optionalTaxaCemiterio = this.taxaCemiterioRepository.findById((Object)taxaCemiterioId);
        if (optionalTaxaCemiterio.isPresent()) {
            return ResponseEntity.ok((Object)taxaCemiterioAtualizada);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{taxaCemiterioId}"})
    public ResponseEntity<Void> deleteTaxaCemiterio(@PathVariable Long taxaCemiterioId) {
        Optional optionalTaxaCemiterio = this.taxaCemiterioRepository.findById((Object)taxaCemiterioId);
        if (optionalTaxaCemiterio.isPresent()) {
            this.taxaCemiterioRepository.deleteById((Object)taxaCemiterioId);
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

