/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.controller;

import br.com.projetoa.apia.modelo.Contribuicao;
import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.repository.DizimistaRepository;
import br.com.projetoa.apia.service.AsaasService;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/webhookWhatsapp"})
public class WhatsAppController {
    @Autowired
    private DizimistaRepository dizimistaRepository;
    @Autowired
    private AsaasService asaasService;

    @PostMapping
    public ResponseEntity<String> handleWebhook(@RequestBody String json) throws IOException, InterruptedException {
        int indexInicioCpf = json.indexOf("\"cpf\":");
        int indexFimCpf = json.indexOf(",", indexInicioCpf);
        int indexInicioFormaPagamento = json.indexOf("\"forma-de-pagamento-79\":");
        int indexFimFormaPagamento = json.indexOf(",", indexInicioFormaPagamento);
        int indexInicioValor = json.indexOf("\"valor\":");
        int indexFimValor = json.indexOf("m", indexInicioValor);
        String valorStr = json.substring(indexInicioValor + "\"valor\":".length(), indexFimValor).replaceAll("\"", "").replaceFirst(",", ".").trim().replace(",", "");
        float valor = this.parseCurrencyString(valorStr).floatValue();
        String cpf = json.substring(indexInicioCpf + "\"cpf\":".length(), indexFimCpf).replaceAll("\"", "").trim();
        String formaPagamento = json.substring(indexInicioFormaPagamento + "\"forma-de-pagamento-79\":".length(), indexFimFormaPagamento).replaceAll("\"", "").trim();
        Optional dizimistaOptional = this.dizimistaRepository.findByCpf(cpf);
        if (dizimistaOptional.isPresent()) {
            Dizimista dizimista = (Dizimista)dizimistaOptional.get();
            Contribuicao contribuicao = new Contribuicao(dizimista, Float.valueOf(valor));
            contribuicao.setTipo("dizimo");
            formaPagamento = formaPagamento.equals("Pix") ? "PIX" : (formaPagamento.equals("Dinheiro") ? "UNDEFINED" : (formaPagamento.equals("Cart\\u00E3o de Cr\\u00E9dito") ? "Cart\u00e3o" : (formaPagamento.equals("Boleto") ? "Boleto" : "UNDEFINED")));
            System.out.println(formaPagamento);
            contribuicao.setOperacao(formaPagamento);
            contribuicao.setDescricao("Realizada via WhatsApp");
            dizimista.getContribuicoes().add(contribuicao);
            this.dizimistaRepository.save((Object)dizimista);
            this.asaasService.criarCobranca(dizimista, contribuicao);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            String dataFormatada = contribuicao.getData().format(formatter);
            String respostaJson = "{\n    \"messages\": [\n        {\n            \"text\": \"Segue a descri\u00e7\u00e3o da contribui\u00e7\u00e3o criada.           Valor: " + valor + "          Para o CPF: " + cpf + "         Vencimento dia " + dataFormatada + "          Link de para pagamento: " + contribuicao.getUrlPagamento() + "\"\n        },\n        {\n            \"fileUrl\": \"" + contribuicao.getUrlPagamento() + "\"\n        },\n        {\n            \"template\": {\n                \"id\": \"ab78cd_oferta\",\n                \"parameters\": {\n                    \"valor\": \"" + valor + "\"\n                }\n            }\n        }\n    ]\n}";
            return new ResponseEntity((Object)respostaJson, (HttpStatusCode)HttpStatus.OK);
        }
        String respostaJson = "{\n    \"messages\": [\n        {\n            \"text\": \"CPF n\u00e3o encontrado!\"\n        },\n        {\n            \"fileUrl\": \"https://xyz.com/boleto.pdf\"\n        },\n        {\n            \"template\": {\n                \"id\": \"ab78cd_oferta\",\n                \"parameters\": {\n                    \"valor\": \"R$ 9,99\"\n                }\n            }\n        }\n    ]\n}";
        return new ResponseEntity((Object)respostaJson, (HttpStatusCode)HttpStatus.OK);
    }

    private Float parseCurrencyString(String currencyString) {
        String cleanedString = currencyString.replaceAll("[^0-9.,]", "");
        cleanedString = cleanedString.replace("R$", "");
        cleanedString = cleanedString.replace(',', '.');
        try {
            return Float.valueOf(Float.parseFloat(cleanedString));
        }
        catch (NumberFormatException e) {
            return Float.valueOf(0.0f);
        }
    }
}

