/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.modelo;

import br.com.projetoa.apia.modelo.Comunidade;
import br.com.projetoa.apia.modelo.UserRole;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
public class Administrador
implements UserDetails {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String nome;
    private String senha;
    private boolean master;
    private Long comunidadeAtiva;
    private UserRole role;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="administrador_comunidade", joinColumns={@JoinColumn(name="administrador_id")}, inverseJoinColumns={@JoinColumn(name="comunidade_id")}, uniqueConstraints={@UniqueConstraint(name="administrador_comunidade_PK", columnNames={"administrador_id", "comunidade_id"})})
    private List<Comunidade> comunidades = new ArrayList();

    public Administrador() {
    }

    public Administrador(String nome, String senha, UserRole role, boolean master) {
        this.nome = nome;
        this.senha = senha;
        this.role = role;
        this.master = master;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public List<Comunidade> getComunidades() {
        return this.comunidades;
    }

    public void setComunidades(List<Comunidade> comunidades) {
        this.comunidades = comunidades;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public Long getComunidadeAtiva() {
        return this.comunidadeAtiva;
    }

    public void setComunidadeAtiva(Long comunidadeAtiva) {
        this.comunidadeAtiva = comunidadeAtiva;
    }

    public UserRole getRole() {
        return this.role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    public void adicionarComunidade(Comunidade comunidade) {
        this.comunidades.add(comunidade);
        comunidade.getAdministradores().add(this);
    }

    public void removerComunidade(Comunidade comunidade) {
        this.comunidades.remove(comunidade);
        comunidade.getAdministradores().remove(this);
    }

    public void addAll(List<Comunidade> comunidades2) {
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.role == UserRole.ADMIN) {
            return List.of(new SimpleGrantedAuthority("ROLE_ADMIN"), new SimpleGrantedAuthority("ROLE_USER"));
        }
        return List.of(new SimpleGrantedAuthority("ROLE_USER"));
    }

    public String getPassword() {
        return this.senha;
    }

    public String getUsername() {
        return this.nome;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

