/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.modelo;

import br.com.projetoa.apia.modelo.Administrador;
import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.modelo.Endereco;
import br.com.projetoa.apia.modelo.Paroquia;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.ArrayList;
import java.util.List;

@Entity
public class Comunidade {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String nome;
    @OneToOne(cascade={CascadeType.ALL})
    private Endereco endereco;
    @JsonIgnore
    @ManyToMany(mappedBy="comunidades", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Administrador> administradores = new ArrayList();
    @JsonIgnore
    @OneToMany
    @JoinColumn(name="comunidade_id")
    private List<Dizimista> dizimistas;
    @ManyToOne
    @JoinColumn(name="paroquia_id")
    private Paroquia paroquia;
    private String code;
    private String codePay;

    public Comunidade() {
    }

    public Comunidade(String nome, Dizimista administrador, Endereco endereco) {
        this.nome = nome;
        this.endereco = endereco;
    }

    public void adicionarDizimista(Dizimista dizimista) {
        this.dizimistas.add(dizimista);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public List<Administrador> getAdministradores() {
        return this.administradores;
    }

    public void setAdministradores(List<Administrador> administradores) {
        this.administradores = administradores;
    }

    public List<Dizimista> getDizimistas() {
        return this.dizimistas;
    }

    public void setDizimistas(List<Dizimista> dizimistas) {
        this.dizimistas = dizimistas;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void adicionarAdministrador(Administrador administrador) {
        this.administradores.add(administrador);
        administrador.getComunidades().add(this);
    }

    public void removerAdministrador(Administrador administrador) {
        this.administradores.remove(administrador);
        administrador.getComunidades().remove(this);
    }

    public String getCodePay() {
        return this.codePay;
    }

    public void setCodePay(String codePay) {
        this.codePay = codePay;
    }
}

