/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.modelo;

import br.com.projetoa.apia.modelo.Atividade;
import br.com.projetoa.apia.modelo.Contribuicao;
import br.com.projetoa.apia.modelo.Endereco;
import br.com.projetoa.apia.modelo.GrupoCemiterio;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

@Entity
public class Dizimista {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String nome;
    private LocalDate nascimento;
    private String cpf;
    @OneToOne(cascade={CascadeType.ALL})
    private Endereco endereco;
    private String telefone;
    private String email;
    @OneToOne
    @JsonBackReference
    private Dizimista conjugue;
    @OneToMany
    @JoinColumn(name="dizimista_id")
    private List<Contribuicao> contribuicoes = new ArrayList();
    private boolean sacBatismo;
    private LocalDate datBatismo;
    private boolean sacComunhao;
    private LocalDate datComunhao;
    private boolean sacCrisma;
    private LocalDate datCrisma;
    private boolean sacCasamento;
    private LocalDate datCasamento;
    private boolean pagouDizimo;
    private boolean ativo;
    private String idAsaas;
    private LocalDate dataCadastro;
    private char sexo;
    @JsonIgnore
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="grupo_cemiterio_id")
    private GrupoCemiterio grupoCemiterio;
    @OneToMany(mappedBy="dizimista", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<Atividade> atividades = new ArrayList();

    public Dizimista() {
    }

    public Dizimista(String nome, LocalDate nascimento, String cpf, Endereco endereco, String telefone, String email) {
        this.nome = nome;
        this.nascimento = nascimento;
        this.cpf = cpf;
        this.endereco = endereco;
        this.telefone = telefone;
        this.email = email;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public LocalDate getNascimento() {
        return this.nascimento;
    }

    public void setNascimento(LocalDate nascimento) {
        this.nascimento = nascimento;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Dizimista getConjugue() {
        return this.conjugue;
    }

    public void setConjugue(Dizimista conjugue) {
        this.conjugue = conjugue;
        if (conjugue != null && !conjugue.equals(this.conjugue)) {
            conjugue.setConjugue(this);
        }
    }

    public List<Contribuicao> getContribuicoes() {
        return this.contribuicoes;
    }

    public void addContribuicao(Contribuicao contribuicao) {
        this.contribuicoes.add(contribuicao);
        contribuicao.setDizimista(this);
    }

    public void setContribuicoes(List<Contribuicao> contribuicoes) {
        this.contribuicoes = contribuicoes;
    }

    public boolean isSacBatismo() {
        return this.sacBatismo;
    }

    public void setSacBatismo(boolean sacBatismo) {
        this.sacBatismo = sacBatismo;
    }

    public LocalDate getDatBatismo() {
        return this.datBatismo;
    }

    public void setDatBatismo(LocalDate datBatismo) {
        this.datBatismo = datBatismo;
    }

    public boolean isSacComunhao() {
        return this.sacComunhao;
    }

    public void setSacComunhao(boolean sacComunhao) {
        this.sacComunhao = sacComunhao;
    }

    public LocalDate getDatComunhao() {
        return this.datComunhao;
    }

    public void setDatComunhao(LocalDate datComunhao) {
        this.datComunhao = datComunhao;
    }

    public boolean isSacCrisma() {
        return this.sacCrisma;
    }

    public void setSacCrisma(boolean sacCrisma) {
        this.sacCrisma = sacCrisma;
    }

    public LocalDate getDatCrisma() {
        return this.datCrisma;
    }

    public void setDatCrisma(LocalDate datCrisma) {
        this.datCrisma = datCrisma;
    }

    public boolean isSacCasamento() {
        return this.sacCasamento;
    }

    public void setSacCasamento(boolean sacCasamento) {
        this.sacCasamento = sacCasamento;
    }

    public LocalDate getDatCasamento() {
        return this.datCasamento;
    }

    public void setDatCasamento(LocalDate datCasamento) {
        this.datCasamento = datCasamento;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro() {
        this.dataCadastro = LocalDate.now();
    }

    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean isPagouDizimo() {
        return this.pagouDizimo;
    }

    public void setPagouDizimo(boolean pagouDizimo) {
        this.pagouDizimo = pagouDizimo;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public String getIdAsaas() {
        return this.idAsaas;
    }

    public void setIdAsaas(String idAsaas) {
        this.idAsaas = idAsaas;
    }

    public String encryptNome(String nome) {
        StringBuilder hexNome = new StringBuilder();
        for (char character : nome.toCharArray()) {
            hexNome.append(Integer.toHexString(character));
        }
        String encryptedNome = this.rotateBitsRight(hexNome.toString(), 4);
        return encryptedNome;
    }

    public String decryptNome(String encryptedNome) {
        String rotatedNome = this.rotateBitsLeft(encryptedNome, 4);
        StringBuilder nome = new StringBuilder();
        for (int i = 0; i < rotatedNome.length(); i += 2) {
            String hexChar = rotatedNome.substring(i, i + 2);
            nome.append((char)Integer.parseInt(hexChar, 16));
        }
        return nome.toString();
    }

    public String encryptCPF(String cpf) {
        StringBuilder hexCPF = new StringBuilder();
        for (char character : cpf.toCharArray()) {
            hexCPF.append(Integer.toHexString(character));
        }
        String encryptedCPF = this.rotateBitsRight(hexCPF.toString(), 7);
        return encryptedCPF;
    }

    public String decryptCPF(String encryptedCPF) {
        String rotatedCPF = this.rotateBitsLeft(encryptedCPF, 7);
        StringBuilder cpf = new StringBuilder();
        for (int i = 0; i < rotatedCPF.length(); i += 2) {
            String hexChar = rotatedCPF.substring(i, i + 2);
            cpf.append((char)Integer.parseInt(hexChar, 16));
        }
        return cpf.toString();
    }

    private String rotateBitsRight(String input, int shift) {
        int length = input.length();
        return input.substring(length - shift) + input.substring(0, length - shift);
    }

    private String rotateBitsLeft(String input, int shift) {
        int length = input.length();
        return input.substring(shift) + input.substring(0, shift);
    }

    public char getSexo() {
        return this.sexo;
    }

    public void setSexo(char sexo) {
        this.sexo = sexo;
    }

    public GrupoCemiterio getGrupoCemiterio() {
        return this.grupoCemiterio;
    }

    public void setGrupoCemiterio(GrupoCemiterio grupoCemiterio) {
        this.grupoCemiterio = grupoCemiterio;
    }

    public List<Atividade> getAtividades() {
        return this.atividades;
    }

    public void setAtividades(List<Atividade> atividades) {
        this.atividades = atividades;
    }
}

