/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.modelo;

import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.modelo.TaxaCemiterio;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.ArrayList;
import java.util.List;

@Entity
public class GrupoCemiterio {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToMany(mappedBy="grupoCemiterio")
    private List<Dizimista> dizimistas = new ArrayList();
    @OneToOne
    private Dizimista administrador;
    @OneToMany(mappedBy="grupoCemiterio", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TaxaCemiterio> taxasCemiterio = new ArrayList();

    public GrupoCemiterio() {
    }

    public GrupoCemiterio(Dizimista administrador) {
        this.administrador = administrador;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Dizimista> getDizimistas() {
        return this.dizimistas;
    }

    public void setDizimistas(List<Dizimista> dizimistas) {
        this.dizimistas = dizimistas;
    }

    public Dizimista getAdministrador() {
        return this.administrador;
    }

    public void setAdministrador(Dizimista administrador) {
        this.administrador = administrador;
    }

    public List<TaxaCemiterio> getTaxasCemiterio() {
        return this.taxasCemiterio;
    }

    public void setTaxasCemiterio(List<TaxaCemiterio> taxasCemiterio) {
        this.taxasCemiterio = taxasCemiterio;
    }

    public void addDizimista(Dizimista dizimista) {
        this.dizimistas.add(dizimista);
        dizimista.setGrupoCemiterio(this);
    }

    public void removeDizimista(Dizimista dizimista) {
        this.dizimistas.remove(dizimista);
    }

    public void addTaxaCemiterio(TaxaCemiterio taxaCemiterio) {
        this.taxasCemiterio.add(taxaCemiterio);
        taxaCemiterio.setGrupoCemiterio(this);
    }

    public void removeTaxaCemiterio(TaxaCemiterio taxaCemiterio) {
        this.taxasCemiterio.remove(taxaCemiterio);
        taxaCemiterio.setGrupoCemiterio(null);
    }

    public void setResponsavel(Dizimista administrador) {
        this.administrador = administrador;
    }

    public void removeTaxaCemiterioById(Long taxaCemiterioId) {
        this.taxasCemiterio.removeIf(t -> t.getId().equals(taxaCemiterioId));
    }
}

