/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.modelo;

import br.com.projetoa.apia.modelo.Comunidade;
import br.com.projetoa.apia.modelo.Endereco;
import br.com.projetoa.apia.modelo.Formacao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.util.ArrayList;
import java.util.List;

@Entity
public class Paroquia {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String nome;
    private String cnpj;
    @OneToOne(cascade={CascadeType.ALL})
    private Endereco endereco;
    @OneToMany
    @JoinColumn(name="paroquia_id")
    private List<Comunidade> comunidades = new ArrayList();
    private String code;
    @JsonIgnore
    @OneToMany(mappedBy="paroquia", cascade={CascadeType.ALL})
    private List<Formacao> formacoes = new ArrayList();

    public Paroquia() {
    }

    public Paroquia(String nome, String cnpj, Endereco endereco) {
        this.nome = nome;
        this.cnpj = cnpj;
        this.endereco = endereco;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public List<Comunidade> getComunidades() {
        return this.comunidades;
    }

    public void setComunidades(List<Comunidade> comunidades) {
        this.comunidades = comunidades;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void adicionarComunidade(Comunidade comunidade) {
        this.comunidades.add(comunidade);
    }

    public Paroquia findParoquiaByComunidade(Comunidade comunidade) {
        for (Comunidade c : this.comunidades) {
            if (!c.getId().equals(comunidade.getId())) continue;
            return this;
        }
        return null;
    }

    public void adicionarFormacao(Formacao formacao) {
        this.formacoes.add(formacao);
        formacao.setParoquia(this);
    }

    public List<Formacao> getFormacoes() {
        return this.formacoes;
    }

    public void setFormacoes(List<Formacao> formacoes) {
        this.formacoes = formacoes;
    }
}

