/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.service;

import br.com.projetoa.apia.modelo.Administrador;
import br.com.projetoa.apia.modelo.Comunidade;
import br.com.projetoa.apia.modelo.Contribuicao;
import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.modelo.GrupoCemiterio;
import br.com.projetoa.apia.modelo.TaxaCemiterio;
import br.com.projetoa.apia.repository.AdministradorRepository;
import br.com.projetoa.apia.repository.ComunidadeRepository;
import br.com.projetoa.apia.repository.ContribuicaoRepository;
import br.com.projetoa.apia.repository.DizimistaRepository;
import br.com.projetoa.apia.repository.GrupoCemiterioRepository;
import br.com.projetoa.apia.repository.TaxaCemiterioRepository;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AsaasService {
    private String urlApi = "https://sandbox.asaas.com/api/v3";
    private String tokenAcesso = "";
    private String carteiraAdriel = "d20fcbfb-e674-499d-82b7-263d367f4c94";
    private float percentualAdriel = 1.5f;
    private String carteiraLucas;
    @Autowired
    private DizimistaRepository dizimistaRepository;
    @Autowired
    private ContribuicaoRepository contribuicaoRepository;
    @Autowired
    private GrupoCemiterioRepository grupoCemiterioRepository;
    @Autowired
    private TaxaCemiterioRepository taxaCemiterioRepository;
    @Autowired
    private ComunidadeRepository comunidadeRepository;
    @Autowired
    private AdministradorRepository administradorRepository;

    public void getCodePay(String nomeAdministradoString) {
        Optional adm = this.administradorRepository.findByNome(nomeAdministradoString);
        long comId = ((Administrador)adm.get()).getComunidadeAtiva();
        Optional comunidade = this.comunidadeRepository.findById(Long.valueOf(comId));
        this.tokenAcesso = ((Comunidade)comunidade.get()).getCodePay();
    }

    public void listaClientes() throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.urlApi + "/customers")).header("accept", "application/json").header("access_token", this.tokenAcesso).method("GET", HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        System.out.println(response.body());
    }

    public void criarClienteAsaas(String nomeAdministrador, Dizimista dizimista) throws IOException, InterruptedException {
        this.getCodePay(nomeAdministrador);
        String jsonBody = String.format("{\"name\":\"%s\",\"cpfCnpj\":\"%s\",\"email\":\"%s\",\"mobilePhone\":\"%s\",\"address\":\"%s\",\"addressNumber\":\"%s\",\"complement\":\"%s\",\"province\":\"%s\",\"postalCode\":\"%s\",\"externalReference\":\"%s\",\"notificationDisabled\":\"true\"}", dizimista.getNome(), dizimista.getCpf(), dizimista.getEmail(), dizimista.getTelefone(), dizimista.getEndereco().getRua(), dizimista.getEndereco().getNumero(), dizimista.getEndereco().getComplemento(), dizimista.getEndereco().getBairro(), dizimista.getEndereco().getCep(), dizimista.getId());
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.urlApi + "/customers")).header("accept", "application/json").header("content-type", "application/json").header("access_token", this.tokenAcesso).method("POST", HttpRequest.BodyPublishers.ofString(jsonBody)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(response.body());
        String asaasCustomerId = rootNode.get("id").asText();
        dizimista.setIdAsaas(asaasCustomerId);
        this.dizimistaRepository.save((Object)dizimista);
    }

    public void criarCobranca(Dizimista dizimista, Contribuicao contribuicao) throws IOException, InterruptedException {
        Optional optionalComunidade = this.comunidadeRepository.findByDizimistasId(dizimista.getId());
        this.tokenAcesso = ((Comunidade)optionalComunidade.get()).getCodePay();
        LocalDateTime dataContribuicao = contribuicao.getData();
        LocalDateTime dataVencimento = dataContribuicao.plusDays(5L);
        String tipoOperacao = contribuicao.getOperacao().equals("PIX") ? "PIX" : (contribuicao.getOperacao().equals("Dinheiro") ? "UNDEFINED" : (contribuicao.getOperacao().equals("Cart\u00e3o") ? "CREDIT_CARD" : (contribuicao.getOperacao().equals("Boleto") ? "BOLETO" : "UNDEFINED")));
        String jsonBody = String.format("{\"billingType\":\"%s\",\"customer\":\"%s\",\"value\":%s,\"dueDate\":\"%s\",\"description\":\"%s\",\"externalReference\":\"%s\"}", tipoOperacao, dizimista.getIdAsaas(), contribuicao.getValor(), dataVencimento.toString(), contribuicao.getDescricao(), contribuicao.getId());
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.urlApi + "/payments")).header("accept", "application/json").header("content-type", "application/json").header("access_token", this.tokenAcesso).method("POST", HttpRequest.BodyPublishers.ofString(jsonBody)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(response.body());
        String asaasPaymentId = rootNode.get("id").asText();
        contribuicao.setIdAsaas(asaasPaymentId);
        contribuicao.setValorAsaas(Float.valueOf(rootNode.get("netValue").floatValue()));
        contribuicao.setStatus(rootNode.get("status").asText());
        contribuicao.setUrlPagamento(rootNode.get("invoiceUrl").asText());
        contribuicao.setDizimista(dizimista);
        this.contribuicaoRepository.save((Object)contribuicao);
        if (contribuicao.getOperacao().equals("Dinheiro")) {
            this.confirmReciveCash(dizimista, contribuicao);
        }
        System.out.println(response.body());
    }

    public void criarTaxa(Dizimista dizimista, TaxaCemiterio taxa, GrupoCemiterio grupoCemiterio) throws IOException, InterruptedException {
        Optional optionalComunidade = this.comunidadeRepository.findByDizimistasId(dizimista.getId());
        this.tokenAcesso = ((Comunidade)optionalComunidade.get()).getCodePay();
        LocalDateTime dataContribuicao = taxa.getData();
        LocalDateTime dataVencimento = dataContribuicao.plusDays(5L);
        String tipoOperacao = taxa.getOperacao().equals("PIX") ? "PIX" : (taxa.getOperacao().equals("Dinheiro") ? "UNDEFINED" : (taxa.getOperacao().equals("Cart\u00e3o") ? "CREDIT_CARD" : (taxa.getOperacao().equals("Boleto") ? "BOLETO" : "UNDEFINED")));
        String jsonBody = String.format("{\"billingType\":\"%s\",\"customer\":\"%s\",\"value\":%s,\"dueDate\":\"%s\",\"description\":\"%s\",\"externalReference\":\"%s\"}", tipoOperacao, dizimista.getIdAsaas(), taxa.getValor(), dataVencimento.toString(), taxa.getDescricao(), taxa.getId());
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.urlApi + "/payments")).header("accept", "application/json").header("content-type", "application/json").header("access_token", this.tokenAcesso).method("POST", HttpRequest.BodyPublishers.ofString(jsonBody)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(response.body());
        String asaasPaymentId = rootNode.get("id").asText();
        taxa.setIdAsaas(asaasPaymentId);
        taxa.setValorAsaas(Float.valueOf(rootNode.get("netValue").floatValue()));
        taxa.setStatus(rootNode.get("status").asText());
        taxa.setUrlPagamento(rootNode.get("invoiceUrl").asText());
        taxa.setGrupoCemiterio(grupoCemiterio);
        this.taxaCemiterioRepository.save((Object)taxa);
        if (taxa.getOperacao().equals("Dinheiro")) {
            this.taxaReciveCash(dizimista, taxa);
        }
        System.out.println(response.body());
    }

    private void confirmReciveCash(Dizimista dizimista, Contribuicao contribuicao) throws IOException, InterruptedException {
        Optional optionalComunidade = this.comunidadeRepository.findByDizimistasId(dizimista.getId());
        this.tokenAcesso = ((Comunidade)optionalComunidade.get()).getCodePay();
        String jsonBody = String.format("{\"notifyCustomer\":false,\"paymentDate\":\"%s\",\"value\":\"%s\"}", contribuicao.getData(), contribuicao.getValor());
        String idPagamento = contribuicao.getIdAsaas();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.urlApi + "/payments/" + idPagamento + "/receiveInCash")).header("accept", "application/json").header("content-type", "application/json").header("access_token", this.tokenAcesso).method("POST", HttpRequest.BodyPublishers.ofString(jsonBody)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(response.body());
        String status = rootNode.get("status").asText();
        contribuicao.setStatus(status);
        contribuicao.setValorAsaas(contribuicao.getValor());
        contribuicao.setUrlPagamento(rootNode.get("invoiceUrl").asText());
        contribuicao.setUrlRecibo(rootNode.get("invoiceUrl").asText());
        this.contribuicaoRepository.save((Object)contribuicao);
        System.out.println(response.body());
    }

    private void taxaReciveCash(Dizimista dizimista, TaxaCemiterio taxaCemiterio) throws IOException, InterruptedException {
        Optional optionalComunidade = this.comunidadeRepository.findByDizimistasId(dizimista.getId());
        this.tokenAcesso = ((Comunidade)optionalComunidade.get()).getCodePay();
        String jsonBody = String.format("{\"notifyCustomer\":false,\"paymentDate\":\"%s\",\"value\":\"%s\"}", taxaCemiterio.getData(), taxaCemiterio.getValor());
        String idPagamento = taxaCemiterio.getIdAsaas();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.urlApi + "/payments/" + idPagamento + "/receiveInCash")).header("accept", "application/json").header("content-type", "application/json").header("access_token", this.tokenAcesso).method("POST", HttpRequest.BodyPublishers.ofString(jsonBody)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(response.body());
        String status = rootNode.get("status").asText();
        taxaCemiterio.setStatus(status);
        taxaCemiterio.setValorAsaas(taxaCemiterio.getValor());
        taxaCemiterio.setUrlPagamento(rootNode.get("invoiceUrl").asText());
        taxaCemiterio.setUrlRecibo(rootNode.get("invoiceUrl").asText());
        this.taxaCemiterioRepository.save((Object)taxaCemiterio);
        System.out.println(response.body());
    }

    public void atualizarClienteAsaas(String nomeAdministrador, Dizimista dizimista) throws IOException, InterruptedException {
        this.getCodePay(nomeAdministrador);
        String jsonBody = String.format("{\"name\":\"%s\",\"cpfCnpj\":\"%s\",\"email\":\"%s\",\"mobilePhone\":\"%s\",\"address\":\"%s\",\"addressNumber\":\"%s\",\"complement\":\"%s\",\"province\":\"%s\",\"postalCode\":\"%s\",\"externalReference\":\"%s\",\"notificationDisabled\":\"true\"}", dizimista.getNome(), dizimista.getCpf(), dizimista.getEmail(), dizimista.getTelefone(), dizimista.getEndereco().getRua(), dizimista.getEndereco().getNumero(), dizimista.getEndereco().getComplemento(), dizimista.getEndereco().getBairro(), dizimista.getEndereco().getCep(), dizimista.getId());
        String idAsaas = dizimista.getIdAsaas();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.urlApi + "/customers/" + idAsaas)).header("accept", "application/json").header("content-type", "application/json").header("access_token", this.tokenAcesso).method("POST", HttpRequest.BodyPublishers.ofString(jsonBody)).build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        System.out.println(response.body());
        this.dizimistaRepository.save((Object)dizimista);
    }
}

