/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.service;

import br.com.projetoa.apia.DTOs.DashboardDTO;
import br.com.projetoa.apia.modelo.Comunidade;
import br.com.projetoa.apia.modelo.Contribuicao;
import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.modelo.Paroquia;
import br.com.projetoa.apia.repository.ComunidadeRepository;
import br.com.projetoa.apia.repository.ParoquiaRepository;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardService {
    @Autowired
    private ComunidadeRepository comunidadeRepository;
    @Autowired
    private ParoquiaRepository paroquiaRepository;

    public DashboardDTO calcularEstatisticasSexo(Long comunidadeId) {
        Comunidade comunidade = this.comunidadeRepository.findById(comunidadeId).orElse(null);
        if (comunidade == null) {
            return null;
        }
        List dizimistas = comunidade.getDizimistas();
        long totalDizimistas = dizimistas.size();
        long totalMasculino = dizimistas.stream().filter(d -> 'M' == d.getSexo()).count();
        long totalFeminino = totalDizimistas - totalMasculino;
        DecimalFormat df = new DecimalFormat("#.##");
        double percentualMasculino = this.parseDoubleSafely(df.format((double)totalMasculino / (double)totalDizimistas * 100.0));
        double percentualFeminino = this.parseDoubleSafely(df.format((double)totalFeminino / (double)totalDizimistas * 100.0));
        DashboardDTO estatisticasSexo = new DashboardDTO(totalDizimistas, totalMasculino, totalFeminino, percentualMasculino, percentualFeminino);
        estatisticasSexo.setTotalDizimistas(totalDizimistas);
        estatisticasSexo.setTotalMasculino(totalMasculino);
        estatisticasSexo.setTotalFeminino(totalFeminino);
        estatisticasSexo.setPercentualMasculino(percentualMasculino);
        estatisticasSexo.setPercentualFeminino(percentualFeminino);
        return estatisticasSexo;
    }

    private double parseDoubleSafely(String value) {
        try {
            return DecimalFormat.getInstance().parse(value).doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public double calcularTotalRecebido(Long comunidadeId) {
        Comunidade comunidade = this.comunidadeRepository.findById(comunidadeId).orElse(null);
        if (comunidade == null) {
            return 0.0;
        }
        List dizimistas = comunidade.getDizimistas();
        double totalRecebido = 0.0;
        for (Dizimista dizimista : dizimistas) {
            List contribuicoes = dizimista.getContribuicoes();
            List<Contribuicao> contribuicoesFiltradas = contribuicoes.stream().filter(contribuicao -> List.of("RECEIVED_IN_CASH", "RECEIVED").contains(contribuicao.getStatus())).toList();
            totalRecebido += contribuicoesFiltradas.stream().mapToDouble(contribuicao -> contribuicao.getValor() != null ? (double)contribuicao.getValor().floatValue() : 0.0).sum();
        }
        return totalRecebido;
    }

    public Map<String, Double> calcularTotalRecebidoPorMes(Long comunidadeId) {
        Comunidade comunidade = this.comunidadeRepository.findById(comunidadeId).orElse(null);
        if (comunidade == null) {
            return this.gerarMapaMesesVazios();
        }
        List dizimistas = comunidade.getDizimistas();
        Map<String, Double> totalRecebidoMensal = dizimistas.stream().flatMap(dizimista -> dizimista.getContribuicoes().stream()).filter(contribuicao -> List.of("RECEIVED_IN_CASH", "RECEIVED").contains(contribuicao.getStatus())).collect(Collectors.groupingBy(contribuicao -> contribuicao.getData().format(DateTimeFormatter.ofPattern("MM-yyyy")), Collectors.summingDouble(contribuicao -> contribuicao.getValor() != null ? (double)contribuicao.getValor().floatValue() : 0.0)));
        LinkedHashMap<String, Double> totalRecebidoOrdenado = new LinkedHashMap<String, Double>();
        LocalDate dataAtual = LocalDate.now();
        for (int i = 0; i < 12; ++i) {
            LocalDate dataMes = dataAtual.minusMonths(i);
            String mesAno = dataMes.format(DateTimeFormatter.ofPattern("MM-yyyy"));
            totalRecebidoOrdenado.putIfAbsent(mesAno, totalRecebidoMensal.getOrDefault(mesAno, 0.0));
        }
        return totalRecebidoOrdenado;
    }

    private Map<String, Double> gerarMapaMesesVazios() {
        LinkedHashMap<String, Double> mesesVazios = new LinkedHashMap<String, Double>();
        LocalDate dataAtual = LocalDate.now();
        for (int i = 0; i < 12; ++i) {
            LocalDate dataMes = dataAtual.minusMonths(i);
            String mesAno = dataMes.format(DateTimeFormatter.ofPattern("MM-yyyy"));
            mesesVazios.put(mesAno, 0.0);
        }
        return mesesVazios;
    }

    public Map<String, Long> calcularIdadesEDistribuicao(Long comunidadeId) {
        Comunidade comunidade = this.comunidadeRepository.findById(comunidadeId).orElse(null);
        if (comunidade == null) {
            return null;
        }
        List dizimistas = comunidade.getDizimistas();
        TreeMap<String, Long> faixasEtarias = new TreeMap<String, Long>();
        for (Dizimista dizimista : dizimistas) {
            int idade = this.calcularIdade(dizimista.getNascimento());
            this.atualizarContagemFaixasEtarias(faixasEtarias, idade);
        }
        System.out.println("Contagem de Dizimistas por Faixa Et\u00e1ria: " + faixasEtarias);
        return faixasEtarias;
    }

    private int calcularIdade(LocalDate dataNascimento) {
        LocalDate dataAtual = LocalDate.now();
        return Period.between(dataNascimento, dataAtual).getYears();
    }

    private void atualizarContagemFaixasEtarias(Map<String, Long> faixasEtarias, int idade) {
        String faixaEtaria = this.determinarFaixaEtaria(idade);
        faixasEtarias.merge(faixaEtaria, 1L, Long::sum);
    }

    private String determinarFaixaEtaria(int idade) {
        if (idade >= 10 && idade < 20) {
            return "10 a 19 anos";
        }
        if (idade >= 20 && idade < 30) {
            return "20 a 29 anos";
        }
        if (idade >= 30 && idade < 40) {
            return "30 a 39 anos";
        }
        if (idade >= 40 && idade < 50) {
            return "40 a 49 anos";
        }
        if (idade >= 50 && idade < 60) {
            return "50 a 59 anos";
        }
        if (idade >= 60 && idade < 70) {
            return "60 a 69 anos";
        }
        if (idade >= 70 && idade < 80) {
            return "70 a 79 anos";
        }
        if (idade >= 80 && idade < 90) {
            return "80 a 89 anos";
        }
        if (idade >= 90 && idade < 100) {
            return "90 a 99 anos";
        }
        return "Outras faixas et\u00e1rias";
    }

    public DashboardDTO calcularEstatisticasSexoParoquia(Long paroquiaId) {
        Paroquia paroquia = this.paroquiaRepository.findById((Object)paroquiaId).orElse(null);
        if (paroquia == null) {
            return null;
        }
        List comunidades = paroquia.getComunidades();
        long totalDizimistasParoquia = 0L;
        long totalMasculinoParoquia = 0L;
        long totalFemininoParoquia = 0L;
        for (Comunidade comunidade : comunidades) {
            List dizimistas = comunidade.getDizimistas();
            long totalDizimistasComunidade = dizimistas.size();
            long totalMasculinoComunidade = dizimistas.stream().filter(d -> 'M' == d.getSexo()).count();
            long totalFemininoComunidade = totalDizimistasComunidade - totalMasculinoComunidade;
            totalDizimistasParoquia += totalDizimistasComunidade;
            totalMasculinoParoquia += totalMasculinoComunidade;
            totalFemininoParoquia += totalFemininoComunidade;
        }
        DecimalFormat df = new DecimalFormat("#.##");
        double percentualMasculinoParoquia = this.parseDoubleSafely(df.format((double)totalMasculinoParoquia / (double)totalDizimistasParoquia * 100.0));
        double percentualFemininoParoquia = this.parseDoubleSafely(df.format((double)totalFemininoParoquia / (double)totalDizimistasParoquia * 100.0));
        DashboardDTO estatisticasSexoParoquia = new DashboardDTO(totalDizimistasParoquia, totalMasculinoParoquia, totalFemininoParoquia, percentualMasculinoParoquia, percentualFemininoParoquia);
        estatisticasSexoParoquia.setTotalDizimistas(totalDizimistasParoquia);
        estatisticasSexoParoquia.setTotalMasculino(totalMasculinoParoquia);
        estatisticasSexoParoquia.setTotalFeminino(totalFemininoParoquia);
        estatisticasSexoParoquia.setPercentualMasculino(percentualMasculinoParoquia);
        estatisticasSexoParoquia.setPercentualFeminino(percentualFemininoParoquia);
        return estatisticasSexoParoquia;
    }

    public double calcularTotalRecebidoParoquia(Long paroquiaId) {
        Paroquia paroquia = this.paroquiaRepository.findById((Object)paroquiaId).orElse(null);
        if (paroquia == null) {
            return 0.0;
        }
        List comunidades = paroquia.getComunidades();
        double totalRecebidoParoquia = 0.0;
        for (Comunidade comunidade : comunidades) {
            totalRecebidoParoquia += this.calcularTotalRecebido(comunidade.getId());
        }
        return totalRecebidoParoquia;
    }

    public Map<String, Double> calcularTotalRecebidoMensalParoquia(Long paroquiaId) {
        Paroquia paroquia = this.paroquiaRepository.findById((Object)paroquiaId).orElse(null);
        if (paroquia == null) {
            return this.gerarMapaMesesVazios();
        }
        List comunidades = paroquia.getComunidades();
        LinkedHashMap<String, Double> totalRecebidoMensalParoquia = new LinkedHashMap<String, Double>();
        for (Comunidade comunidade : comunidades) {
            Map totalRecebidoMensalComunidade = this.calcularTotalRecebidoPorMes(comunidade.getId());
            for (Map.Entry entry : totalRecebidoMensalComunidade.entrySet()) {
                String mesAno = (String)entry.getKey();
                double valor = (Double)entry.getValue();
                totalRecebidoMensalParoquia.merge(mesAno, valor, Double::sum);
            }
        }
        return totalRecebidoMensalParoquia;
    }

    public Map<String, Long> calcularIdadesEDistribuicaoParoquia(Long paroquiaId) {
        Paroquia paroquia = this.paroquiaRepository.findById((Object)paroquiaId).orElse(null);
        if (paroquia == null) {
            return null;
        }
        List comunidades = paroquia.getComunidades();
        TreeMap<String, Long> faixasEtariasParoquia = new TreeMap<String, Long>();
        for (Comunidade comunidade : comunidades) {
            Map faixasEtariasComunidade = this.calcularIdadesEDistribuicao(comunidade.getId());
            for (Map.Entry entry : faixasEtariasComunidade.entrySet()) {
                String faixaEtaria = (String)entry.getKey();
                long count = (Long)entry.getValue();
                faixasEtariasParoquia.merge(faixaEtaria, count, Long::sum);
            }
        }
        return faixasEtariasParoquia;
    }

    public long calcularDizimistasAtivosParoquia(Long paroquiaId) {
        Paroquia paroquia = this.paroquiaRepository.findById((Object)paroquiaId).orElse(null);
        if (paroquia == null) {
            return 0L;
        }
        List comunidades = paroquia.getComunidades();
        return comunidades.stream().flatMap(comunidade -> comunidade.getDizimistas().stream()).filter(Dizimista::isAtivo).count();
    }

    public long calcularDizimistasInativosParoquia(Long paroquiaId) {
        Paroquia paroquia = this.paroquiaRepository.findById((Object)paroquiaId).orElse(null);
        if (paroquia == null) {
            return 0L;
        }
        List comunidades = paroquia.getComunidades();
        return comunidades.stream().flatMap(comunidade -> comunidade.getDizimistas().stream()).filter(dizimista -> !dizimista.isAtivo()).count();
    }

    public long calcularTotalFieisParoquia(Long paroquiaId) {
        Paroquia paroquia = this.paroquiaRepository.findById((Object)paroquiaId).orElse(null);
        if (paroquia == null) {
            return 0L;
        }
        List comunidades = paroquia.getComunidades();
        return comunidades.stream().flatMap(comunidade -> comunidade.getDizimistas().stream()).count();
    }
}

