/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.service;

import br.com.projetoa.apia.modelo.Comunidade;
import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.modelo.Endereco;
import br.com.projetoa.apia.repository.ComunidadeRepository;
import br.com.projetoa.apia.repository.DizimistaRepository;
import br.com.projetoa.apia.repository.EnderecoRepository;
import br.com.projetoa.apia.service.AsaasService;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DizimistaService {
    @Autowired
    private DizimistaRepository dizimistaRepository;
    @Autowired
    private ComunidadeRepository comunidadeRepository;
    @Autowired
    private EnderecoRepository enderecoRepository;
    @Autowired
    AsaasService asaasService;

    public void importCSV(String nomeAdministrador, MultipartFile file, Long comunidadeId) throws IOException, CsvException, InterruptedException {
        try (InputStreamReader reader = new InputStreamReader(file.getInputStream());){
            CSVReader csvReader = new CSVReaderBuilder((Reader)reader).withSkipLines(1).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(';').build()).build();
            List rows = csvReader.readAll();
            for (String[] row : rows) {
                Dizimista dizimista = new Dizimista();
                if (row[0] == "") continue;
                dizimista.setNome(row[0]);
                dizimista.setNascimento(DizimistaService.converterStringParaLocalDate((String)row[1]));
                dizimista.setCpf(row[2]);
                Endereco endereco = new Endereco(row[3], row[4], row[5]);
                endereco.setBairro(row[8]);
                endereco.setCep(Long.parseLong(row[9]));
                endereco.setComplemento(row[10]);
                endereco.setNumero(Integer.parseInt(row[11]));
                this.enderecoRepository.save((Object)endereco);
                dizimista.setEndereco(endereco);
                dizimista.setTelefone(row[6]);
                dizimista.setEmail(row[7]);
                dizimista.setDataCadastro(LocalDate.now());
                dizimista.setAtivo(true);
                dizimista.setPagouDizimo(true);
                this.dizimistaRepository.save((Object)dizimista);
                this.asaasService.criarClienteAsaas(nomeAdministrador, dizimista);
                Optional optionalComunidade = this.comunidadeRepository.findById(comunidadeId);
                if (!optionalComunidade.isPresent()) continue;
                Comunidade comunidade = (Comunidade)optionalComunidade.get();
                comunidade.adicionarDizimista(dizimista);
                Comunidade comunidade2 = (Comunidade)this.comunidadeRepository.save((Object)comunidade);
            }
        }
    }

    public static LocalDate converterStringParaLocalDate(String dataString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        LocalDate dataLocalDate = LocalDate.parse(dataString, formatter);
        return dataLocalDate;
    }
}

