/*
 * Decompiled with CFR 0.152.
 */
package br.com.projetoa.apia.service;

import br.com.projetoa.apia.modelo.Comunidade;
import br.com.projetoa.apia.modelo.Dizimista;
import br.com.projetoa.apia.repository.ComunidadeRepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@EnableScheduling
public class EnvioWhatsappService {
    @Autowired
    private ComunidadeRepository comunidadeRepository;
    @PersistenceContext
    private EntityManager entityManager;
    private final String endpointUrl = "https://hook.us1.make.com/85wieb1j1zw8kl8rach4npmpjrqolgvg";

    @Scheduled(cron="0 00 08 * * *")
    public void verificarAniversariantes() {
        LocalDate hoje = LocalDate.now();
        List comunidades = this.entityManager.createQuery("SELECT DISTINCT c FROM Comunidade c JOIN FETCH c.dizimistas", Comunidade.class).getResultList();
        comunidades.forEach(comunidade -> comunidade.getDizimistas().stream().filter(dizimista -> dizimista.getNascimento().getMonth() == hoje.getMonth() && dizimista.getNascimento().getDayOfMonth() == hoje.getDayOfMonth()).forEach(dizimista -> {
            System.out.println("Mensagem para " + dizimista.getNome());
            try {
                this.enviarMensagemAniversario(dizimista);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        }));
    }

    private CompletableFuture<Void> enviarMensagemAniversario(Dizimista dizimista) throws IOException, InterruptedException {
        try {
            Object telefoneFormatado = dizimista.getTelefone().replaceAll("[^0-9]", "");
            telefoneFormatado = ((String)telefoneFormatado).replaceFirst("^0+(?!$)", "");
            if (((String)telefoneFormatado).startsWith("0")) {
                telefoneFormatado = "4" + (String)telefoneFormatado;
            }
            String jsonBody = "{\"nome\": \"" + dizimista.getNome() + "\", \"telefone\": \"" + (String)telefoneFormatado + "\", \"tipo\": \"aniversario\"}";
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://hook.us1.make.com/85wieb1j1zw8kl8rach4npmpjrqolgvg")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build();
            return client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 200) {
                    System.out.println("Mensagem de anivers\u00e1rio enviada com sucesso para: " + dizimista.getNome());
                } else {
                    System.out.println("Falha ao enviar mensagem de anivers\u00e1rio para: " + dizimista.getNome());
                }
                return null;
            });
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return CompletableFuture.completedFuture(null);
        }
    }
}

